#include <iostream>
#include <vector>
#include <algorithm>
#include <set>
#include <map>
#include <unordered_set>
#include <unordered_map>
#include <numeric>
#include <cmath>
#include <string>
#include <random>
using namespace std;

using ll = long long;

const ll INF = 1e9;
const ll LLINF = 1e18;
const ll MOD1 = 1e9 + 7;
const ll MOD2 = 1e9 + 1000 - 7;
const ll BASE = 32;

mt19937 rnd(1000 - 7);

struct DSU {
    vector<int> p, r;
    DSU(int _size) {
        p.assign(_size, 0);
        iota(p.begin(), p.end(), 0);
        r.assign(_size, 0);
    }

    int get(int i) {
        if (p[i] == i) {
            return i;
        }
        return p[i] = get(p[i]);
    }

    void merge(int a, int b) {
        a = get(a);
        b = get(b);
        if (a == b) {
            return;
        }
        if (r[a] < r[b]) {
            swap(a, b);
        }
        p[b] = a;
        if (r[a] == r[b]) {
            r[a]++;
        }
    }
};

struct Segtree {
    vector<ll> a;
    vector<ll> t;
    
    ll merge(ll a, ll b) {
        return max(a, b);
    }

    void build(int v, int l, int r) {
        if (r - l == 1) {
            t[v] = a[l];
            return;
        }
        int mid = (l + r) / 2;
        build(2 * v + 1, l, mid);
        build(2 * v + 2, mid, r);
        t[v] = merge(t[2 * v + 1], t[2 * v + 2]);
    }

    void add(int v, int l, int r, int qi, ll x) {
        if (qi < l || r <= qi) {
            return;
        }
        if (r - l == 1) {
            t[v] += x;
            return;
        }
        int mid = (l + r) / 2;
        add(2 * v + 1, l, mid, qi, x);
        add(2 * v + 2, mid, r, qi, x);
        t[v] = merge(t[2 * v + 1], t[2 * v + 2]);
    }

    ll get(int v, int l, int r, int ql, int qr) {
        if (qr <= l || r <= ql) {
            return -LLINF;
        }
        if (ql <= l && r <= qr) {
            return t[v];
        }
        int mid = (l + r) / 2;
        ll r1 = get(2 * v + 1, l, mid, ql, qr);
        ll r2 = get(2 * v + 2, mid, r, ql, qr);
        return merge(r1, r2);
    }
};

struct Shrink {
    vector<ll> a;

    Shrink(vector<ll>& _a) {
        a = _a;
        sort(a.begin(), a.end());
        a.resize(unique(a.begin(), a.end()) - a.begin());
    }

    int get(ll x) {
        return lower_bound(a.begin(), a.end(), x) - a.begin();
    }

    ll rget(int x) {
        return a[x];
    }
};

struct Hash {
    vector<pair<ll, ll>> h, p;
    
    Hash(const string& s) {
        h.resize(s.size() + 1);
        h[0] = { 0, 0 };
        p.resize(s.size() + 1);
        p[0] = { 1, 1 };
        for (int i = 1; i <= s.size(); ++i) {
            h[i].first = ((h[i - 1].first * BASE) + (s[i] - 'a' + 1)) % MOD1;
            h[i].second = ((h[i - 1].second * BASE) + (s[i] - 'a' + 1)) % MOD2;
            p[i].first = (p[i - 1].first * BASE) % MOD1;
            p[i].second = (p[i - 1].second * BASE) % MOD2;
        }
    }


};

void scan(vector<ll>& a) {
    for (int i = 0; i < a.size(); ++i) {
        cin >> a[i];
    }
}

void print(vector<ll>& a) {
    for (int i = 0; i < a.size(); ++i) {
        cout << a[i] << " ";
    }
}

ll x, y;

ll solve() {
    if (x == y) {
        return 0;
    }
    vector<ll> dels;
    ll k = 1;
    for (; k * k <= (y - x); ++k) {
        if ((y - x) % k == 0) {
            dels.push_back(k);
            dels.push_back((y - x) / k);
        }
    }
    ll tmin = x - 1;
    for (int i = 0; i < dels.size(); ++i) {
        ll t = x - (y - x) / dels[i];
        if (t < 0)
            continue;
        tmin = min(tmin, t);
    }
    // cout << (x - tmin) << " " << (y - tmin) << "\n";
    return tmin;
}

ll solveDumb() {
    for (int t = 0; t < x; ++t) {
        if ((t - y) % (t - x) == 0) {
            return t;
        }
    }
    return x - 1;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int t = 1;
    cin >> t;
    while (t--) {
        cin >> x >> y;
        //x = rnd() % 10000 + 1;
        //y = rnd() % 10000 + 1;
        //if (x > y) {
        //    swap(x, y);
        //}
        //ll r1 = solve();
        //ll r2 = solveDumb();
        //cout << r1 << " " << r2 << "\n";
        //if (r1 != r2) {
        //    solveDumb();
        //    solve();
        //}
        cout << solve() << "\n";
    }
}